/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.html;

import icyllis.annotations.NotNull;
import icyllis.flexmark.html.AttributeProvider;
import icyllis.flexmark.html.IndependentAttributeProviderFactory;
import icyllis.flexmark.html.renderer.AttributablePart;
import icyllis.flexmark.html.renderer.LinkResolverContext;
import icyllis.flexmark.util.ast.Node;
import icyllis.flexmark.util.html.Attributes;
import icyllis.flexmark.util.html.MutableAttributes;
import icyllis.flexmark.util.sequence.BasedSequence;

public class EmbeddedAttributeProvider
implements AttributeProvider {
    public static final IndependentAttributeProviderFactory Factory = new IndependentAttributeProviderFactory(){

        @Override
        @NotNull
        public AttributeProvider apply(@NotNull LinkResolverContext context) {
            return new EmbeddedAttributeProvider();
        }
    };

    EmbeddedAttributeProvider() {
    }

    @Override
    public void setAttributes(@NotNull Node node, @NotNull AttributablePart part, @NotNull MutableAttributes attributes) {
        Node firstChild;
        if (part == AttributablePart.NODE && (firstChild = node.getChildOfType(EmbeddedNodeAttributes.class)) instanceof EmbeddedNodeAttributes) {
            attributes.addValues(((EmbeddedNodeAttributes)firstChild).attributes);
        }
    }

    public static class EmbeddedNodeAttributes
    extends Node {
        @NotNull
        final Attributes attributes;

        public EmbeddedNodeAttributes(@NotNull Node parent, @NotNull Attributes attributes) {
            super(parent.getChars().subSequence(0, 0));
            this.attributes = attributes;
        }

        @Override
        @NotNull
        public BasedSequence[] getSegments() {
            return Node.EMPTY_SEGMENTS;
        }

        @Override
        public void astString(@NotNull StringBuilder out, boolean withExtra) {
            out.append(EmbeddedNodeAttributes.class.getSimpleName());
            out.append("[").append(this.getStartOffset()).append(", ").append(this.getEndOffset()).append("]");
            out.append(", attributes: ").append(this.attributes.toString());
            if (withExtra) {
                this.getAstExtra(out);
            }
        }

        @Override
        public void astExtraChars(@NotNull StringBuilder out) {
        }
    }
}

